
#include "app.h"
LPDIRECT3DTEXTURE8 TexMenu;
LPDIRECT3DTEXTURE8 TexPreview;
LPDIRECT3DTEXTURE8 TexPreview2;
IDirect3DTexture8 *TexScreen=NULL;
IDirect3DTexture8 *TexResize=NULL;
int TexWidth=640,TexHeight=480;

// Blank the texture:
int TexBlank()
{
  D3DLOCKED_RECT lock={0,NULL};
  unsigned char *dest=NULL;
  int y=0,line=0;

  TexScreen->LockRect(0,&lock,NULL,0); if (lock.pBits==NULL) return 1;

  dest=(unsigned char *)lock.pBits;
  for (y=0; y<TexHeight; y++,line+=lock.Pitch)
  {
    memset(dest+line,0,TexWidth<<1);
  }

  TexScreen->UnlockRect(0);
  return 0;
}

int TexScreenInit()
{
  TexWidth =640;
  TexHeight=480;
  

  //g_pd3dDevice->CreateTexture(clipx * 2, clipy * 2 + 4, 1, 0, D3DFMT_LIN_R5G6B5 , NULL, &Texture);
  Device->CreateTexture(TexWidth, TexHeight, 0, 0L, D3DFMT_LIN_R5G6B5, D3DPOOL_DEFAULT, &TexScreen);
  
  //dprintf("Trying to create texture\n");
  //D3DXCreateTexture(Device, 640, 480, 0, 0, D3DFMT_LIN_R5G6B5, D3DPOOL_DEFAULT, &TexScreen);
  //D3DXCreateTexture(Device, 640, 480, 0, 0, D3DFMT_LIN_R5G6B5, D3DPOOL_DEFAULT, &TexScreen);
  if (TexScreen==NULL) { dprintf("Failed to create texture\n"); return 1; }


  /*
  HRESULT D3DXCreateTextureFromFileW(
  LPDIRECT3DDEVICE8 pDevice,
  LPCWSTR pSrcFile,
  LPDIRECT3DTEXTURE8* ppTexture
);  
  */
  //Device->CreateTexture(TexWidth,TexHeight,1,0,D3DFMT_R5G6B5,D3DPOOL_MANAGED,&TexMenu);
  if( FAILED( D3DXCreateTextureFromFile(Device, "D:\\media\\rombrowser.jpg", &TexMenu ) ) )
    {
		dprintf("Failed to create load texture rombrowser.jpg\n");
     exit(-1);
	}


	if( FAILED( D3DXCreateTextureFromFile(Device, "D:\\media\\previewnotfound.jpg", &TexPreview2 ) ) )
    {
		dprintf("Failed to create texture previewnotfound.jpg\n");
     exit(-1);
	}

	if( FAILED( D3DXCreateTextureFromFile(Device, "D:\\media\\resize.jpg", &TexResize ) ) )
    {
		dprintf("Failed to create texture resize.jpg\n");
     exit(-1);
	}

  dprintf("Before texblank\n");
  //TexBlank();
  dprintf("After texblank\n");


  D3DSURFACE_DESC desc;
    TexScreen->GetLevelDesc( 0, &desc );
    DWORD dwTexWidth  = desc.Width;
    DWORD dwTexHeight = desc.Height;
    DWORD dwTexDepth  = 0;


  D3DLOCKED_RECT lock;
    TexScreen->LockRect( 0, &lock, 0, 0L );
    VOID* pBits = lock.pBits;


	//dprintf("TexWidth: %d, TexHeight: %d, pitch: %d\n", dwTexWidth, dwTexHeight, lock.Pitch);
	// Loop through and touch the texels.
	for( DWORD y = 0; y < dwTexHeight; y++ )
	{
		for( DWORD x = 0; x < dwTexWidth; x++ )
		{
			//((WORD*)pBits)[y*dwTexWidth+x] = (WORD)(((x>>3)<<11) | ((y>>3)<<0));
			((unsigned short*)pBits)[y*dwTexWidth+x] = 0;//0x00FF;
		}
	}
    TexScreen->UnlockRect( 0 );



  return 0;
}

void TexScreenExit()
{
  RELEASE(TexScreen)
  TexWidth=TexHeight=0;
}

#include <xgraphics.h>

// Copy screen to a swizzled texture
int TexScreenSwizzle()
{
	D3DSURFACE_DESC desc;
    TexScreen->GetLevelDesc( 0, &desc );
    DWORD dwTexWidth  = desc.Width;
    DWORD dwTexHeight = desc.Height;
    DWORD dwTexDepth  = 0;

	D3DLOCKED_RECT lock;
    TexScreen->LockRect( 0, &lock, 0, 0L );
    VOID* pBits = lock.pBits;


	//dprintf("TexWidth: %d, TexHeight: %d, pitch: %d\n", dwTexWidth, dwTexHeight, lock.Pitch);
	// Loop through and touch the texels.
	for( DWORD y = 0; y < dwTexHeight; y++ )
	{
		for( DWORD x = 0; x < dwTexWidth; x++ )
		{
			//((WORD*)pBits)[y*dwTexWidth+x] = (WORD)(((x>>3)<<11) | ((y>>3)<<0));
			((unsigned short*)pBits)[y*dwTexWidth+x] = (unsigned short)(EmuScreen[y*dwTexWidth+x]);
		}
	}
    TexScreen->UnlockRect( 0 );


/*
   D3DLOCKED_RECT lock={0,NULL};
   TexScreen->LockRect(0,&lock,NULL,0);
   unsigned short* dest = (unsigned short*) lock.pBits;
   for(int y = 0; y < 480; y++) {
	   for(int x = 0; x < 640; x++) {
	       dest[x + (y * (lock.Pitch / 2))] = EmuScreen[x + (y * 640)];
	   }
   }

   */
   //TexScreen->UnlockRect(0);


	/*
  D3DLOCKED_RECT lock={0,NULL};
  unsigned char *dest=NULL;
  int y=0,sy=0,mask=0;
  unsigned short *ps=NULL;

  mask=TexWidth*TexHeight-1;

  TexScreen->LockRect(0,&lock,NULL,0); if (lock.pBits==NULL) return 1;

  dest=(unsigned char *)lock.pBits;
  ps=EmuScreen;

  // Write to swizzled locations:
  for (y=0,sy=0; y<EmuHeight; y++,sy++)
  {
    int x=0,sx=0;
    sy|=0x55555555;

    for (x=0,sx=0; x<EmuWidth; x++,sx++)
    {
      int addr=0;

      sx|=0xaaaaaaaa;
      addr=sx&sy&mask; // Calculate swizzled address

      ((unsigned short *)dest)[addr]=*ps++;
    }
  }
  TexScreen->UnlockRect(0);
*/


//DOXXX
	/*
	RECT src, dst;
	byte *curr1, *curr2 ;
	//dprintf("Swizzle 1\n");
	D3DSURFACE_DESC desc;
    //dprintf("Swizzle 2\n");
	TexScreen->GetLevelDesc(0, &desc);
	
	RECT rectSource;
	rectSource.top = 0;
	rectSource.left = 0;
	rectSource.bottom = 480 - 1 ;
	rectSource.right  = 640 - 1;

	LPPOINT p;
	p->x = 0;
	p->y = 0;
	//dprintf("Swizzle 3\n");
	// Lock the rect in our texture
	D3DLOCKED_RECT d3dlr;
	//dprintf("Swizzle 4\n");
	TexScreen->LockRect(0, &d3dlr, &rectSource, 0);
	//dprintf("Swizzle 5\n");
	XGSwizzleRect((byte*)EmuScreen, 640*2, &rectSource, d3dlr.pBits, 640, 480, p, 16/8);
	//dprintf("Swizzle 6\n");
	TexScreen->UnlockRect(0);
    //dprintf("Swizzle 7\n");
	*/
  return 0;
}








#include <xgraphics.h>





int TexScreenLinear()
{

	/*
  D3DLOCKED_RECT lock={0,NULL};
  unsigned short *dest=NULL;
  
  TexScreen->LockRect(0,&lock,NULL,0); if (lock.pBits==NULL) return 1;
  dest=(unsigned short *)lock.pBits;

  for(int y = 0; y < 480; y++) {

	  for(int x = 0; x < 640; x++) {
	     dest[x + (y * (lock.Pitch / 2))] = EmuScreen[x + (y * 640)];      
	  }

  }

  TexScreen->UnlockRect(0);
*/
  return 0;
}

/*

int offset = ( x + y * 640) * bytesPerPixel;

This will not work though if there is padding at the end of each row. Instead we need to advance by stride bytes. So the calculation becomes:

int offset = x * bytesPerPixel + y * pitch;





 D3DLOCKED_RECT lock={0,NULL};
  unsigned char *dest=NULL;
  int y=0,line=0;
  unsigned short *ps=NULL;

  TexScreen->LockRect(0,&lock,NULL,0); if (lock.pBits==NULL) return 1;

  dest=(unsigned char *)lock.pBits;
  ps=EmuScreen;

  for (y=0; y<EmuHeight; y++,line+=lock.Pitch)
  {
    int x=0;
    int addr=line;

    for (x=0; x<EmuWidth; x++,addr+=2)
    {
      *(unsigned int *)(dest+addr)=*ps++;
    }
  }

  TexScreen->UnlockRect(0);
  return 0;
*/
